<?php
	$title = "Script Resources - Developers";
	require "structures/header.php";
?>

<div class="span9">
	<ul class="breadcrumb">
		<li><a href="index.php">Home</a> <span class="divider">/</span></li>
		<li><a href="tools.php">Tools</a> <span class="divider">/</span></li>
		<li><a href="tools-developers.php">Developers</a> <span class="divider">/</span></li>
		<li class="active">Script Resources</li>
	</ul>
	
	<div class="page-header">
		<h2>Script Resources</h2>
	</div>
	
	<div style="float: right;">
		<dl>
            <dt>
              <b>Available Libraries</b>
            </dt>
            <dd>
              <a href="#angularjs">AngularJS</a>
            </dd>
            <dd>
              <a href="#chrome-frame">Chrome Frame</a>
            </dd>
            <dd>
              <a href="#dojo">Dojo</a>
            </dd>
            <dd>
              <a href="#ext-core">Ext Core</a>
            </dd>
            <dd>
              <a href="#jquery">jQuery</a>
            </dd>
            <dd>
              <a href="#jquery-ui">jQuery UI</a>
            </dd>
            <dd>
              <a href="#mootools">MooTools</a>
            </dd>
            <dd>
              <a href="#prototype">Prototype</a>
            </dd>
            <dd>
              <a href="#scriptaculous">script_aculo_us</a>
            </dd>
            <dd>
              <a href="#swfobject">SWFObject</a>
            </dd>
            <dd>
              <a href="#webfont">WebFont Loader</a>
            </dd>
          </dl>
		</div>
	
	<div class="alert alert-info alert-block" style="width: 820px;">
	  <button type="button" class="close" data-dismiss="alert">&times;</button>
	  <h4>Wait a second!</h4>
	  We recommend Bootstrap for all web developers. It comes with all the needed tools for development and makes it far much more easy to launch platforms,
	  faster than ever before. Give it a try! <a href="http://www.getbootstrap.com/">Visit the Bootstrap Website!</a>
	</div>
	
	<div id="angularjs">
    <dl>
      <dt>AngularJS</dt>
      <dd>
        <strong>snippet:</strong>
        <code class="snippet">&lt;script
          src="//ajax.googleapis.com/ajax/libs/angularjs/1.0.6/angular.min.js"&gt;&lt;/script&gt;</code>
      </dd>
      <dd>
        <strong>site:</strong>
        <a href="http://angularjs.org" target="_blank">http://angularjs.org</a>
      </dd>
      <dd class="versions">
        <strong>stable versions:</strong>
        <span class="versions">1.0,6, 1.0.5, 1.0.4, 1.0.3, 1.0.2, 1.0.1</span>
      </dd>
      <dd class="versions">
        <strong>unstable versions:</strong>
        <span class="versions">1.1.4, 1.1.3</span>
      </dd>
    </dl>
  </div>

  <div id="chrome-frame">
    <dl>
      <dt>Chrome Frame</dt>
      <dd>
        <strong>snippet:</strong>
        <code class="snippet">&lt;script
          src="//ajax.googleapis.com/ajax/libs/chrome-frame/1.0.3/CFInstall.min.js"&gt;&lt;/script&gt;</code>
      </dd>
      <dd>
        <strong>site:</strong>
        <a href="https://developers.google.com/chrome/chrome-frame/"
           target="_blank">
          https://developers.google.com/chrome/chrome-frame/</a>
      </dd>
      <dd class="versions">
        <strong>versions:</strong>
        <span class="versions">1.0.3, 1.0.2, 1.0.1, 1.0.0</span>
      </dd>
    </dl>
  </div>

  <div id="dojo">
    <dl>
      <dt>Dojo</dt>
      <dd>
        <strong>snippet:</strong>
        <code class="snippet">&lt;script
          src="//ajax.googleapis.com/ajax/libs/dojo/1.9.0/dojo/dojo.js"&gt;&lt;/script&gt;</code>
      </dd>
      <dd>
        <strong>site:</strong>
        <a href="http://dojotoolkit.org/"
           target="_blank">http://dojotoolkit.org/</a>
      </dd>
      <dd>
        <strong>versions:</strong>
        <span class="versions">1.9.0, 1.8.4, 1.8.3, 1.8.2, 1.8.1,
          1.8.0, 1.7.4, 1.7.3, 1.7.2, 1.7.1, 1.7.0, 1.6.1, 1.6.0,
          1.5.2, 1.5.1, 1.5.0, 1.4.4, 1.4.3, 1.4.1, 1.4.0, 1.3.2,
          1.3.1, 1.3.0, 1.2.3, 1.2.0, 1.1.1</span>
      </dd>
    </dl>
  </div>

  <div id="ext-core">
    <dl>
      <dt>Ext Core</dt>
      <dd>
        <strong>snippet:</strong>
        <code class="snippet">&lt;script
          src="//ajax.googleapis.com/ajax/libs/ext-core/3.1.0/ext-core.js"&gt;&lt;/script&gt;</code>
      </dd>
      <dd>
        <strong>site:</strong>
        <a href="http://www.sencha.com/products/extjs/"
           target="_blank">http://www.sencha.com/products/extjs/</a>
      </dd>
      <dd class="versions">
        <strong>versions:</strong>
        <span class="versions">3.1.0, 3.0.0</span>
      </dd>
    </dl>
  </div>

  <div id="jquery">
    <dl>
      <dt>jQuery</dt>
      <dd>
        <strong>snippet:</strong>
        <code class="snippet">&lt;script
          src="//ajax.googleapis.com/ajax/libs/jquery/2.0.0/jquery.min.js"&gt;&lt;/script&gt;</code>
      </dd>
      <dd>
        <strong>site:</strong>
        <a href="http://jquery.com/" target="_blank">http://jquery.com/</a>
      </dd>
      <dd>
        <strong>versions:</strong>
        <span class="versions">2.0.0, 1.9.1, 1.9.0, 1.8.3, 1.8.2,
          1.8.1, 1.8.0, 1.7.2, 1.7.1, 1.7.0, 1.6.4, 1.6.3, 1.6.2,
          1.6.1, 1.6.0, 1.5.2, 1.5.1, 1.5.0, 1.4.4, 1.4.3, 1.4.2,
          1.4.1, 1.4.0, 1.3.2, 1.3.1, 1.3.0, 1.2.6, 1.2.3</span>
      </dd>
      <dd><strong>note:</strong> 1.2.5 and 1.2.4 are not hosted due to
        their short and unstable lives in the wild.</dd>
    </dl>
  </div>

  <div id="jquery-ui">
    <dl>
      <dt>jQuery UI</dt>
      <dd>
        <strong>snippet:</strong>
        <code class="snippet">&lt;script
          src="//ajax.googleapis.com/ajax/libs/jqueryui/1.10.3/jquery-ui.min.js"&gt;&lt;/script&gt;</code>
      </dd>
      <dd>
        <strong>site:</strong>
        <a href="http://jqueryui.com/" target="_blank">http://jqueryui.com/</a>
      </dd>
      <dd>
        <strong>versions:</strong>
        <span class="versions">1.10.3, 1.10.2, 1.10.1, 1.10.0, 1.9.2, 1.9.1,
          1.9.0, 1.8.24, 1.8.23, 1.8.22, 1.8.21, 1.8.20, 1.8.19, 1.8.18,
          1.8.17, 1.8.16, 1.8.15, 1.8.14, 1.8.13, 1.8.12, 1.8.11, 1.8.10,
          1.8.9, 1.8.8, 1.8.7, 1.8.6, 1.8.5, 1.8.4, 1.8.2, 1.8.1,
          1.8.0, 1.7.3, 1.7.2, 1.7.1, 1.7.0, 1.6.0, 1.5.3, 1.5.2</span>
      </dd>
      <dd><strong>note:</strong> This library depends on jQuery. You must also
        load jQuery before loading this module. Version 1.8.3 is not hosted due
        to its short life, and the alias <code>1.8.3</code> actually loads
        1.8.4.
      </dd>
    </dl>
  </div>

  <div id="mootools">
    <dl>
      <dt>MooTools</dt>
      <dd>
        <strong>snippet:</strong>
        <code class="snippet">&lt;script
          src="//ajax.googleapis.com/ajax/libs/mootools/1.4.5/mootools-yui-compressed.js"&gt;&lt;/script&gt;</code>
      </dd>
      <dd>
        <strong>site:</strong>
        <a href="http://mootools.net/" target="_blank">http://mootools.net/</a>
      </dd>
      <dd>
        <strong>versions:</strong>
        <span class="versions">1.4.5, 1.4.4, 1.4.3, 1.4.2, 1.4.1,
          1.4.0, 1.3.2, 1.3.1, 1.3.0, 1.2.5, 1.2.4, 1.2.3, 1.2.2,
          1.2.1, 1.1.2, 1.1.1</span>
      </dd>
    </dl>
  </div>

  <div id="prototype">
    <dl>
      <dt>Prototype</dt>
      <dd>
        <strong>snippet:</strong>
        <code class="snippet">&lt;script
          src="//ajax.googleapis.com/ajax/libs/prototype/1.7.1.0/prototype.js"&gt;&lt;/script&gt;</code>
      </dd>
      <dd>
        <strong>site:</strong>
        <a href="http://prototypejs.org/" target="_blank">http://prototypejs.org/</a>
      </dd>
      <dd class="versions">
        <strong>versions:</strong>
        <span class="versions">1.7.1.0, 1.7.0.0, 1.6.1.0, 1.6.0.3,
          1.6.0.2</span>
      </dd>
    </dl>
  </div>

  <div id="scriptaculous">
    <dl>
      <dt>script.aculo.us</dt>
      <dd>
        <strong>snippet:</strong>
        <code class="snippet">&lt;script
          src="//ajax.googleapis.com/ajax/libs/scriptaculous/1.9.0/scriptaculous.js"&gt;&lt;/script&gt;</code>
      </dd>
      <dd>
        <strong>site:</strong>
        <a href="http://script.aculo.us/" target="_blank">http://script.aculo.us/</a>
      </dd>
      <dd class="versions">
        <strong>versions:</strong>
        <span class="versions">1.9.0, 1.8.3, 1.8.2, 1.8.1</span>
      </dd>
      <dd><strong>note:</strong> This library depends
        on <code>Prototype</code>. Before loading this module, you must
        load Prototype.</dd>
    </dl>
  </div>

  <div id="swfobject">
    <dl>
      <dt>SWFObject</dt>
      <dd>
        <strong>snippet:</strong>
        <code class="snippet">&lt;script
          src="//ajax.googleapis.com/ajax/libs/swfobject/2.2/swfobject.js"&gt;&lt;/script&gt;</code>
      </dd>
      <dd>
        <strong>site:</strong>
        <a href="http://code.google.com/p/swfobject/" target="_blank">
          http://code.google.com/p/swfobject/</a>
      </dd>
      <dd class="versions">
        <strong>versions:</strong>
        <span class="versions">2.2, 2.1</span>
      </dd>
    </dl>
  </div>

  <div id="webfont">
    <dl>
      <dt>WebFont Loader</dt>
      <dd>
        <strong>snippet:</strong>
        <code class="snippet">&lt;script
          src="//ajax.googleapis.com/ajax/libs/webfont/1.4.2/webfont.js"&gt;&lt;/script&gt;</code>
      </dd>
      <dd>
        <strong>site:</strong>
        <a href="https://developers.google.com/webfonts/docs/webfont_loader" target="_blank">
          https://developers.google.com/webfonts/docs/webfont_loader</a>
      </dd>
      <dd>
        <strong>versions:</strong>
        <span class="versions">1.4.2, 1.3.0, 1.1.2, 1.1.1, 1.1.0, 1.0.31, 1.0.30, 1.0.29, 1.0.28, 1.0.27, 1.0.26,
          1.0.25, 1.0.24, 1.0.23, 1.0.22, 1.0.21, 1.0.19, 1.0.18,
          1.0.17, 1.0.16, 1.0.15, 1.0.14, 1.0.13, 1.0.12, 1.0.11,
          1.0.10, 1.0.9, 1.0.6, 1.0.5, 1.0.4, 1.0.3, 1.0.2, 1.0.1,
          1.0.0</span></dd>
    </dl>
  </div>
</div>

<?php
	require "structures/footer.php";
?>
